/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event;

import mods.flammpfeil.slashblade.event.AnvilCraftingRecipe;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AnvilCrafting {
    private static final ResourceLocation REFORGE = new ResourceLocation("slashblade", "tips/reforge");

    public static AnvilCrafting getInstance() {
        return SingletonHolder.instance;
    }

    private AnvilCrafting() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onAnvilUpdateEvent(AnvilUpdateEvent event) {
        ItemStack base = event.getLeft();
        ItemStack material = event.getRight();
        if (base.m_41619_()) {
            return;
        }
        if (material.m_41619_()) {
            return;
        }
        AnvilCraftingRecipe recipe = AnvilCraftingRecipe.getRecipe(material);
        if (recipe == null) {
            return;
        }
        if (!recipe.matches(base)) {
            return;
        }
        event.setMaterialCost(1);
        event.setCost(recipe.getLevel());
        event.setOutput(recipe.getResult(base));
    }

    @SubscribeEvent
    public void onAnvilRepairEvent(AnvilRepairEvent event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ItemStack material = event.getRight();
        AnvilCraftingRecipe recipe = AnvilCraftingRecipe.getRecipe(material);
        if (recipe == null) {
            return;
        }
        ItemStack base = event.getLeft();
        if (!recipe.matches(base)) {
            return;
        }
        AdvancementHelper.grantCriterion((ServerPlayer)event.getEntity(), REFORGE);
    }

    private static final class SingletonHolder {
        private static final AnvilCrafting instance = new AnvilCrafting();

        private SingletonHolder() {
        }
    }
}

